/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.Active;
import io.github.apace100.origins.power.NightVisionPower;
import io.github.apace100.origins.power.PowerType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;

public class ToggleNightVisionPower
extends NightVisionPower
implements Active {
    private boolean isActive;
    private Active.Key key;

    public ToggleNightVisionPower(PowerType<?> type, PlayerEntity player) {
        this(type, player, 1.0f, true);
    }

    public ToggleNightVisionPower(PowerType<?> type, PlayerEntity player, float strength, boolean activeByDefault) {
        super(type, player, strength);
        this.isActive = activeByDefault;
    }

    @Override
    public void onUse() {
        this.isActive = !this.isActive;
        OriginComponent.sync(this.player);
    }

    @Override
    public boolean isActive() {
        return this.isActive && super.isActive();
    }

    @Override
    public INBT toTag() {
        return ByteNBT.func_229672_a_((boolean)this.isActive);
    }

    @Override
    public void fromTag(INBT tag) {
        if (tag instanceof ByteNBT) {
            this.isActive = ((ByteNBT)tag).func_150290_f() > 0;
        }
    }

    @Override
    public Active.Key getKey() {
        return this.key;
    }

    @Override
    public void setKey(Active.Key key) {
        this.key = key;
    }
}

